import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    myRefunds: [],
    loading: true,
    isRefresh: false,
    nextPageUrl: "",
    loadMore: false,
};

export const getMyRefunds = createAsyncThunk(
    "user/getMyRefunds",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const data = await queryResponse(URL, "GET", access_token);
        return data;
    }
);
export const getMoreRefunds = createAsyncThunk(
    "user/getMoreRefunds",
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const data = await queryResponse(URL, "GET", access_token);
        return data;
    }
);

const getMyRefundsSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetRefundList: (state) => {
            state.myRefunds = [];
            state.loading = true;
            state.isRefresh = false;
        },
        fetchRefundStart: (state) => {
            state.isRefresh = true;
        },
        getMyRefundsSuccree: (state, { payload }) => {
            state.myRefunds = payload;
            state.loading = false;
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getMyRefunds.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getMyRefunds.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                state.myRefunds = data;
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loading = false;
        });
        builder.addCase(getMyRefunds.rejected, (state) => {
            state.loading = false;
        });
        builder.addCase(getMoreRefunds.pending, (state) => {
            state.loadMore = true;
        });
        builder.addCase(getMoreRefunds.fulfilled, (state, { payload }) => {
            const {
                status: { code } = {},
                records: { pagination, data } = {},
            } = payload || {};
            if (code === 200) {
                state.myRefunds = [...state.myRefunds, ...data];
                state.nextPageUrl = pagination?.next_page_url;
            }
            state.loadMore = false;
        });
        builder.addCase(getMoreRefunds.rejected, (state) => {
            state.loadMore = false;
        });
    },
});

export const { resetRefundList, fetchRefundStart, getMyRefundsSuccree } =
    getMyRefundsSlice.actions;
export default getMyRefundsSlice.reducer;
